﻿/* --------------------------------------------------------------------------------
*  <copyright file="Program.cs" company="Hybrid Software Helix Ltd">
*    Copyright (c) 2025 Hybrid Software Helix Ltd. All rights reserved.
*  </copyright>
*  <summary>
*    This example is provided on an "as is" basis and without warranty of any kind.
*    Hybrid Software Helix Ltd. does not warrant or make any representations
*    regarding the use or results of use of this example.
*  </summary>
* ---------------------------------------------------------------------------------
*/

using JawsMako;
using static JawsMako.jawsmakoIF_csharp;

namespace MyProgramCS;

internal class Program
{
    static int Main(string[] args)
    {
        try
        {
            var mako = IJawsMako.create();
            IJawsMako.enableAllFeatures(mako);
            var assembly = IDocumentAssembly.create(mako);
            var document = IDocument.create(mako);
            assembly.appendDocument(document);
            var page = IPage.create(mako);
            document.appendPage(page);
            var fixedPage = IDOMFixedPage.create(mako);
            page.setContent(fixedPage);

            //TODO...

            IPDFOutput.create(mako).writeAssembly(assembly, "test.pdf");
        }
        catch (MakoException e)
        {
            string errorFormatString = getEDLErrorString(e.m_errorCode);
            Console.WriteLine("Exception thrown: " + e.m_msg);
        }

        catch (Exception e)
        {
            Console.WriteLine($"Exception thrown: {e}");
        }

        return 0;
    }
}